     d getRows         s             10i 0 inz(%elem(data))
     d gotRows         s             10i 0
     d data            ds                  qualified dim(500)
     d  workDept                      3a
     d  empno                         6a
     d  firstName                    12a   varying
     d  lastName                     15a   varying

     d getDept         s              3a
     d getHired        s               d
     d getBirth        s               d

     d myStatement     s           2000a   varying
     d myWhere         s            100a   varying
     d pad_And         s              5a   varying
     d parmNo          s             10i 0
(A)  d descName        s             20a   varying inz('TEST_DESC')

     d ADD_AND         c                   ' and '
     d ADD_WHERE       c                   ' where '
(B)  d ADD_DEPT        c                   ' workDept = ? '
     d ADD_HIRE        c                   ' hiredate >= ? '
     d ADD_BIRTH       c                   ' birthdate >= ? '

      /free
       exec SQL
(C)       allocate descriptor local :descName with max 3;

       if (getDept <> *blanks);
(D)       myWhere = ADD_DEPT;
          pad_And = ADD_AND;
          parmNo += 1;
          exec SQL
             set descriptor :descName
(E)             value :parmNo type = 1,
                              length = 3,
                              data = :getDept;
       endIf;

       if (getHired <> d'0001-01-01');
(F)       myWhere += pad_And + ADD_HIRE;
          pad_And = ADD_AND;
          parmNo += 1;
          exec SQL
             set descriptor :descName
(G)             value :parmNo type = 9,
                              datetime_interval_code = 1,
                              data = :getHired;
       endIf;

       if (getBirth <> d'0001-01-01');
(F)       myWhere += pad_And + ADD_BIRTH;
          pad_And = ADD_AND;
          parmNo += 1;
          exec SQL
             set descriptor :descName
(G)             value :parmNo type = 9,
                              datetime_interval_code = 1,
                              data = :getBirth;
       endIf;

       if (parmNo > 0);
          myWhere = ADD_WHERE + myWhere;
       endIf;

       myStatement = 'select workDept, empno, firstname, lastname ' +
                     ' from employee ' +
                     myWhere +
                     ' order by workDept, empno';

       exec SQL
(H)       set descriptor :descName count = :parmNo;

       exec SQL
          prepare D1 from :myStatement;

       if SQLCode = 0;
          exec SQL
             declare C1 scroll cursor for D1;

          exec SQL
(I)          open C1 using SQL descriptor :descName;

          exec SQL
             fetch first from C1 for :getRows rows into :data;

          gotRows = SQLErrd(3);

          exec SQL
             close C1;
       endIf;

       exec SQL
(J)       deallocate descriptor local :descName;

       *inLR = *on;
      /end-Free
	  
A. Hoewel je een vaste naam kan geven aan een descriptor werk je idealiter met een veld. Je kan descriptors doorgeven met hun inhoud naar andere programma's in dezelfde job (niet noodzakelijk call stack).
Ik gebruik dit in de nieuwe versie van onze JSON routines gebaseerd op NoxDB dan kan je immers ook persistent werken door bijv. hier een sessienummer voor te gebruiken.

B. Constanten om de WHERE statement mee op te bouwen. Geen Quotes nodig als je ? gebruikt als replacement. Met descriptor kan je hier ook een naam gebruiken maar ?
is makkelijker zoals je zal zien in de code.

C. We moeten de descriptor alloceren en het MAXIMAAL aantal parameters / velden opgeven. Descriptors kunnen ook de select columns, ... zijn.
De local duid aan dat we die enkel in ons programma gebruiken. Een Global is zoals een local data area gekend voor de ganse job en zal de inhoud ook houden.

D. Hier controleer ik op de departement code en moet ik de data toevoegen aan de descriptor.

E. SET DESCRIPTOR zet de waarde voor de parameter en heeft ook de waarde van de parameter nummer (zoveelste ? in de statement). Gezien we dit dynamisch vullen tellen we die bij het opvullen/opmaken van de statement.
De parameter TYPE duid aan welk data type de parameter is (1 is character). LENGTH is de lengte van de data en data is natuurlijk de waarde die gebruikt wordt in de where clause.

F. Zelfde voor velden Hire Date en Date of Birth.

G. TYPE is 9 voordate/time/timestamp en DATE_TIME_INTERVAL_CODE 1 geeft aan dat het een date field is.

H. SET DESCRIPTOR with COUNT is gebruikt om aan te geven hoeveel parameters we gebruikt / opgevuld hebben van de maximale 3.

I. We openen de cursor met de SQL descriptor die onze parameters bevat. Voordeel hier is dat dit SQL injectie totaal onmogelijk maakt.

J. Deallocate de descriptor om memory terug vrij te maken.