﻿select trunc_timestamp(ohconfdate, 'MONTH') as date,
       count(*) as count
from kwfoamdta.ordrhdr
group by trunc_timestamp(ohconfdate, 'MONTH')
order by 1;

select trunc_timestamp(ohconfdate, 'MONTH') as datum,
       count(*) as count,
       lag(count(*),1)  over(patition by trunc_timestamp(ohconfdate, 'MONTH') order by trunc_timestamp(ohconfdate, 'MONTH'))
from kwfoamdta.ordrhdr
group by trunc_timestamp(ohconfdate, 'MONTH')
order by datum;
       
 

WITH MonthlySales AS (
select trunc_timestamp(ohconfdate, 'MONTH') as Maand,
       count(*) as Aantal
from kwfoamdta.ordrhdr
group by trunc_timestamp(ohconfdate, 'MONTH')
)
SELECT q.*,
       lag(aantal,1)  over(order by Maand) as Vorige 
  FROM MonthlySales q
ORDER BY Maand;

WITH MonthlySales AS (
select trunc_timestamp(ohconfdate, 'MONTH') as Maand,
       count(*) as Aantal
from kwfoamdta.ordrhdr
group by trunc_timestamp(ohconfdate, 'MONTH')
)
SELECT q.*,
      100 * (aantal - lag(aantal,1) over(order by Maand) / lag(aantal,1)  over(order by Maand)) || ' %' as growth
  FROM MonthlySales q
ORDER BY Maand;


select bimper, 
       sum(count(*)) over (order by bimper) as total_users_monthly
from common.pfbew
group by bimper;


select bimper, 
       sum(count(*)) over (order by bimper) as total_users_monthly,
       log(sum(count(*)) over (order by bimper)) as log_total_users_monthly
from common.pfbew
group by bimper;


select bimper,
       row_number() over (order by bimper) as dp, 
       sum(count(*)) over (order by bimper) as total_users_monthly,
       log(sum(count(*)) over (order by bimper)) as log_total_users_monthly
from common.pfbew
group by bimper;


select regr_slope(log_total_users_monthly, dp),
       regr_intercept(log_total_users_monthly, dp) 
from (
select bimper,
       row_number() over (order by bimper) as dp, 
       sum(count(*)) over (order by bimper) as total_users_monthly,
       log(sum(count(*)) over (order by bimper)) as log_total_users_monthly
from common.pfbew
group by bimper
) b ;



with dummy(id) as (
    select 1 from SYSIBM.SYSDUMMY1    
    union all
    select id + 1 from dummy where id + 1 between 1 and 6
)
select id from dummy;

/* filling the gap in a series */

with series as (SELECT
    d.min + num.n DAYS as dag
FROM
    -- create inline table with min max date
    (VALUES(DATE('2023-01-01'), DATE('2023-04-01'))) AS d(min, max)
INNER JOIN
    -- create inline table with numbers from 0 to 999
    (
        SELECT
            n1.n + n10.n + n100.n AS n
        FROM
            (VALUES(0),(1),(2),(3),(4),(5),(6),(7),(8),(9)) AS n1(n)
        CROSS JOIN
            (VALUES(0),(10),(20),(30),(40),(50),(60),(70),(80),(90)) AS n10(n)
        CROSS JOIN
            (VALUES(0),(100),(200),(300),(400),(500),(600),(700),(800),(900)) AS n100(n)
    ) AS num
ON
    d.min + num.n DAYS<= d.max
ORDER BY
    num.n)
select dag, 
 coalesce(sum(ohtotprice), 0) as sales
 from series
 left join kwfoamdta.ordrhdr on  dag = ordrhdr.ohconfdate  
 group by dag
  ;

/* test files */

select *
from kwfoamdta.ordrhdr;

set schema kwfoamdta;

select *
from
    ( select 5,
            ohorderid,
            ohtotprice
    from ordrhdr
    union select 1,
                'total',
                sum(ohtotprice)
                from ordrhdr
    union select 2,
                'avg',
                avg(ohtotprice)
    from ordrhdr
    union select 3,
                'min',
                min(ohtotprice)
    from ordrhdr
    union select 4,
                'max',
                max(ohtotprice)
    from ordrhdr) stats
order by 1;
    



select 
    case 
        when ohtotprice between 10 and 100 then '10-100' 
        when ohtotprice between 101 and 20000 then '100-20000'
        else '20000+'
    end as ohtotprice_band, 
    count(*) 
from ordrhdr
group by ohtotprice
order by ohtotprice;


select quartile , min(bbedeu), max(bbedeu)
from (
    select bbedeu, 
    ntile(4) over (order by bbedeu) as quartile from common.pfbew
) x  
group by quartile 
order by quartile ;


    select ohtotprice, 
    ntile(4) over (order by ohtotprice) from ordrhdr;





