﻿/* Calculating Running Total in SQL */
select bimpd,
       count(balgrk) as count,
       sum(count(balgrk)) over (order by bimpd) as running_total
from cd.pfbew
group by bimpd
order by bimpd;

/* Calculating Running/Moving Average in SQL */
select bimper, 
       bbedeu, 
       avg(bbedeu) over (order by bimper rows between 3 preceding and current row)
from cd.pfbew;

/* Calculating Weighted Moving Average in SQL */

select kvmjjmm, kvmaant, row_number() over () 
from qs36f.klmodvm;
quarter	revenue	row_number
;


select extract(MONTH FROM baudtim),
    bwsube, 
    bwaant / sum(bwaant) over(partition by extract(MONTH FROM baudtim))
from kwfoamdta.cdartbew; 

select extract(MONTH FROM baudtim),
    bwsube, 
    first_value(bwaant) over(partition by extract(MONTH FROM baudtim))
from kwfoamdta.cdartbew; 

select dt,
    price,
    first_value(price) over (partition by date_trunc('month', dt))
from trades;



select country, 
       city,
       population, 
       row_number() over (order by population desc) as country_rank           
from cities;

/* finding duplicate rows in SQL */
set schema cdkoen;


select email,
       count(*)
from dedup
group by email
having count(*) > 1;

select row_number() over (partition by email),
       name,
       email
from dedup;

select coalesce(null, 'love', 'sql');
-- returns love


select * from (
    select row_number() over (partition by email) as rij,
        name,
        email
    from dedup ) t 
where t.rij < 2;

select listagg(trim(name),  ',') within group(order by name desc) from dedup ;

select email, substr(email,1,locate('@',email)-1) as name, substr(email,locate('@',email)+1, length(substr(email,locate('@',email)+1))) as domain from dedup;

select first_name, age, gender
from users
order by gender desc nulls last;

SELECT
    d.min + num.n DAYS
FROM
    -- create inline table with min max date
    (VALUES(DATE('2015-02-28'), DATE('2016-03-01'))) AS d(min, max)
INNER JOIN
    -- create inline table with numbers from 0 to 999
    (
        SELECT
            n1.n + n10.n + n100.n AS n
        FROM
            (VALUES(0),(1),(2),(3),(4),(5),(6),(7),(8),(9)) AS n1(n)
        CROSS JOIN
            (VALUES(0),(10),(20),(30),(40),(50),(60),(70),(80),(90)) AS n10(n)
        CROSS JOIN
            (VALUES(0),(100),(200),(300),(400),(500),(600),(700),(800),(900)) AS n100(n)
    ) AS num
ON
    d.min + num.n DAYS<= d.max
ORDER BY
    num.n;
 
 
set schema kwfoamdta;    

